#ifndef ZMODELER_STRUCT_FACE_H_INCLUDED
#define ZMODELER_STRUCT_FACE_H_INCLUDED

/*********************************************************************
-----------------   tFace class discription:  ------------------------
This class difines a structure of the single face includeing following
fields:
  tIndex  I1  - index of the first vertex in the vertextable
  tIndex  I2  - index of the second vertex in the vertextable
  tIndex  I3  - index of the third vertex in the vertextable
  float  U1,  U2,  U3,
      V1,  V2,  V3
        - coordinates of UV map for each vertex;
  long    TexturePage
        - Index of texture page (material)
  DWORD    nRenderFlags
        - combinatin of renderflags: (chromic, semitransp, etc.)
*********************************************************************/


class DllExport tFace: public tAbstract
{
public:
//--------------------------
//  data members
  tIndex  I1;
  tIndex  I2;
  tIndex  I3;
  float  U1,  U2,  U3,
        V1,  V2,  V3;
  long  Material;

  long  PairIndex;    // -1 if none;

  DWORD  nRenderFlags;  //custom render flags 0x00000000 by default;
  DWORD  nBlendFlags;  //custom blending flags 0x00000000 by default;
  DWORD  nWrapFlags;    //custom blending flags 0x00000000 by default;

  union
  {
        DWORD   reserv1; 
        DWORD   othervalue1;
    };
  union
  {
        DWORD   reserv2; 
        DWORD   othervalue2;
    };
  union
  {
        DWORD   reserv3; 
        DWORD   othervalue3;
    };
    

//--------------------------
//  construction

  tFace();
  tFace(tIndex i1, tIndex i2, tIndex i3);
  tFace(tIndex i1, tIndex i2, tIndex i3, DWORD RFlags);
  void Reorient();//swaps 1 and 2 info to make other side visible
  void MakeFace(tIndex p1, tIndex p2, tIndex p3);//inits face's I1,I2 and I3 values.
//--------------------------
//  operators
  tFace& operator= (const tFace& f);
};

#endif

